const http2 = require('http2')
const fs = require('fs')

const logFile = fs.createWriteStream('ssl-keys.log', { flags: 'a' })

const server = http2.createSecureServer({
  key: fs.readFileSync('localhost-privkey.pem'),
  cert: fs.readFileSync('localhost-cert.pem')
})

server.on('error', (err) => console.error(err))

server.on('stream', (stream, headers) => {
  // stream is a Duplex
  stream.respond({
    'content-type': 'text/html',
    ':status': 200
  })
  stream.end('<h1>Hello World</h1>')
})

server.on('keylog', (line, tlsSocket) => {
  logFile.write(line)
})

server.listen(8443)
