const http2 = require('http2')
const fs = require('fs')

function requestMap (paths) {
  let promise = new Promise((resolve, reject) => {
    var results = {}
    var outstanding = 0
    paths.forEach(path => {
      outstanding++
      let req = client.request({ ':path': path })
      results[path] = {'data': '', 'req': req}
      req.on('response', (headers, flags) => {
        results[path].headers = headers
      })
      req.on('data', (chunk) => {
        results[path].data += chunk
      })
      req.on('end', () => {
        outstanding--
        if (outstanding === 0) {
          for (var path in results) {
            results[path].req.end()
          }
          resolve(results)
        }
      })
      req.setEncoding('utf8')
    })
  })
  return promise
}

var widgetIds = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10].map(p => `/${p}`)

var client = http2.connect('https://localhost:8443/', {
  ca: fs.readFileSync('localhost-cert.pem')
})
client.on('error', (err) => console.error(`ERROR: ${err}`))

requestMap(widgetIds).then(results => {
  for (var path in results) {
    console.log(`${path} - ${results[path].headers[':status']}`)
  }
  client.close()
})
